# Cronjob Configuration for Yilick Platform

This file contains all the required cronjobs that need to be set up on your server for the Yilick platform to function properly.

## Prerequisites

- SSH access to your server
- Crontab access
- PHP CLI available
- Correct path to your Laravel installation

## How to Set Up Cronjobs

1. SSH into your server
2. Open crontab editor: `crontab -e`
3. Add the cronjobs listed below
4. Save and exit

## Required Cronjobs

### 1. Laravel Task Scheduler (REQUIRED)
This is the main Laravel scheduler that handles all scheduled tasks.

```bash
* * * * * cd /path/to/yilick && php artisan schedule:run >> /dev/null 2>&1
```

**Important:** Replace `/path/to/yilick` with your actual project path.

**What it does:**
- Runs every minute
- Executes all scheduled Laravel tasks
- This is the ONLY cronjob you need if you use Laravel's scheduler

---

### 2. Auto-Bump Listings (REQUIRED)
Automatically bumps listings for users with active premium subscriptions.

```bash
0 * * * * cd /path/to/yilick && php artisan listings:auto-bump >> /dev/null 2>&1
```

**Schedule:** Every hour at minute 0
**What it does:**
- Bumps listings based on package settings:
  - Basic: Every 24 hours
  - Pro: Every 12 hours
  - Premium: Every 6 hours
- Only bumps listings that haven't been bumped within their interval
- Unlimited bumps for subscribed users

**Alternative (More Frequent):**
```bash
*/30 * * * * cd /path/to/yilick && php artisan listings:auto-bump >> /dev/null 2>&1
```
Runs every 30 minutes for more responsive bumping.

---

### 3. Process Expired Promotions (OPTIONAL)
Cleans up expired featured listings and promotions.

```bash
0 0 * * * cd /path/to/yilick && php artisan tinker --execute="app(App\Services\PremiumService::class)->processExpiredPromotions();" >> /dev/null 2>&1
```

**Schedule:** Daily at midnight
**What it does:**
- Marks expired promotions as inactive
- Removes featured status from expired listings
- Keeps database clean

---

### 4. Database Backup (RECOMMENDED)
Regular database backups for data safety.

```bash
0 2 * * * cd /path/to/yilick && php artisan backup:run >> /dev/null 2>&1
```

**Schedule:** Daily at 2:00 AM
**What it does:**
- Creates database backup
- Stores in configured backup location
- Requires `spatie/laravel-backup` package

**Note:** You need to install the backup package first:
```bash
composer require spatie/laravel-backup
```

---

### 5. Clear Expired Sessions (OPTIONAL)
Cleans up old session data.

```bash
0 3 * * * cd /path/to/yilick && php artisan session:gc >> /dev/null 2>&1
```

**Schedule:** Daily at 3:00 AM
**What it does:**
- Removes expired session files
- Frees up disk space
- Only needed if using file-based sessions

---

### 6. Queue Worker (If Using Queues)
Process queued jobs for emails, notifications, etc.

```bash
* * * * * cd /path/to/yilick && php artisan queue:work --stop-when-empty >> /dev/null 2>&1
```

**Schedule:** Every minute
**What it does:**
- Processes queued jobs
- Sends emails, notifications
- Handles background tasks

**Alternative (Supervisor - RECOMMENDED for production):**
Use Supervisor instead of cron for queue workers. See Laravel documentation.

---

## Complete Crontab Example

Here's a complete example of all cronjobs together:

```bash
# Laravel Task Scheduler (REQUIRED)
* * * * * cd /var/www/yilick && php artisan schedule:run >> /dev/null 2>&1

# Auto-Bump Listings (REQUIRED)
0 * * * * cd /var/www/yilick && php artisan listings:auto-bump >> /dev/null 2>&1

# Process Expired Promotions (Daily at midnight)
0 0 * * * cd /var/www/yilick && php artisan tinker --execute="app(App\Services\PremiumService::class)->processExpiredPromotions();" >> /dev/null 2>&1

# Database Backup (Daily at 2 AM)
0 2 * * * cd /var/www/yilick && php artisan backup:run >> /dev/null 2>&1

# Clear Expired Sessions (Daily at 3 AM)
0 3 * * * cd /var/www/yilick && php artisan session:gc >> /dev/null 2>&1
```

---

## Shared Hosting Setup

If you're on shared hosting without SSH access:

### Option 1: cPanel Cron Jobs
1. Log into cPanel
2. Go to "Cron Jobs"
3. Add each command with the appropriate schedule
4. Use full paths to PHP binary (e.g., `/usr/bin/php`)

Example:
```
0 * * * * /usr/bin/php /home/username/public_html/artisan listings:auto-bump
```

### Option 2: Web Cron Services
Use external services like:
- EasyCron (https://www.easycron.com/)
- Cron-Job.org (https://cron-job.org/)
- SetCronJob (https://www.setcronjob.com/)

Create a web endpoint that triggers the command:
```php
// routes/web.php
Route::get('/cron/auto-bump/{secret}', function($secret) {
    if ($secret !== env('CRON_SECRET')) {
        abort(403);
    }
    Artisan::call('listings:auto-bump');
    return 'Auto-bump completed';
});
```

Then schedule the web cron service to hit:
```
https://yourdomain.com/cron/auto-bump/your-secret-key
```

---

## Cron Schedule Syntax Reference

```
* * * * * command to execute
│ │ │ │ │
│ │ │ │ └─── Day of week (0-7, Sunday = 0 or 7)
│ │ │ └───── Month (1-12)
│ │ └─────── Day of month (1-31)
│ └───────── Hour (0-23)
└─────────── Minute (0-59)
```

**Examples:**
- `* * * * *` - Every minute
- `0 * * * *` - Every hour
- `*/30 * * * *` - Every 30 minutes
- `0 0 * * *` - Daily at midnight
- `0 2 * * *` - Daily at 2 AM
- `0 0 * * 0` - Weekly on Sunday at midnight

---

## Troubleshooting

### Cronjob Not Running?

1. **Check crontab is saved:**
   ```bash
   crontab -l
   ```

2. **Check cron service is running:**
   ```bash
   sudo service cron status
   ```

3. **Check PHP path:**
   ```bash
   which php
   ```

4. **Test command manually:**
   ```bash
   cd /path/to/yilick && php artisan listings:auto-bump
   ```

5. **Check logs:**
   ```bash
   tail -f /var/log/syslog | grep CRON
   ```

6. **Enable logging:**
   ```bash
   0 * * * * cd /path/to/yilick && php artisan listings:auto-bump >> /var/log/yilick-cron.log 2>&1
   ```

### Permission Issues?

Make sure the cron user has permission to:
- Read/write to storage directory
- Execute artisan commands
- Access database

```bash
chmod -R 775 storage bootstrap/cache
chown -R www-data:www-data storage bootstrap/cache
```

---

## Monitoring

### Check Last Run Time
```bash
php artisan schedule:list
```

### Test Auto-Bump Manually
```bash
php artisan listings:auto-bump
```

Expected output:
```
Starting auto-bump process...
Bumped 15 listings for user 5 (Package: Pro)
Bumped 8 listings for user 12 (Package: Basic)
Auto-bump completed. Total listings bumped: 23
```

---

## Important Notes

1. **Always use absolute paths** in cronjobs
2. **Test commands manually** before adding to cron
3. **Monitor logs** for the first few days
4. **Set up alerts** for failed cronjobs
5. **Document any custom cronjobs** you add

---

## Support

If you encounter issues:
1. Check Laravel logs: `storage/logs/laravel.log`
2. Check cron logs: `/var/log/syslog` or `/var/log/cron`
3. Verify database connectivity
4. Ensure all migrations are run
5. Check file permissions

---

**Last Updated:** December 21, 2025
**Platform:** Yilick Classified Ads Platform
**Laravel Version:** 11.x
