<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\BusinessFeedback;
use Illuminate\Http\Request;
use Illuminate\View\View;
use Illuminate\Http\RedirectResponse;

class FeedbackController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request): View
    {
        $status = $request->query('status', 'pending');

        $feedbacks = BusinessFeedback::with(['business', 'user'])
            ->when($status !== 'all', function ($query) use ($status) {
                return $query->where('moderation_status', $status);
            })
            ->latest()
            ->paginate(15)
            ->withQueryString();

        return view('admin.feedback.index', compact('feedbacks', 'status'));
    }

    /**
     * Update the moderation status of the feedback.
     */
    public function updateStatus(Request $request, BusinessFeedback $feedback): RedirectResponse
    {
        $request->validate([
            'status' => 'required|in:approved,rejected,pending',
        ]);

        $feedback->update([
            'moderation_status' => $request->status,
            'reviewed_by_user_id' => auth()->id(),
            'reviewed_at' => now(),
        ]);

        return back()->with('success', 'Feedback status updated successfully.');
    }
}
