<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Http\Resources\ApiResponse;
use App\Http\Resources\BusinessResource;
use App\Http\Resources\BusinessFeedbackResource;
use App\Models\Business;
use App\Models\BusinessFeedback;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class BusinessPublicController extends Controller
{
    public function showBySlug(Request $request, string $slug): JsonResponse
    {
        $business = Business::where('slug', $slug)
            ->withCount(['followers', 'listings'])
            ->firstOrFail();

        return ApiResponse::success(new BusinessResource($business));
    }

    public function feedbackBySlug(Request $request, string $slug): JsonResponse
    {
        $business = Business::where('slug', $slug)->firstOrFail();

        $perPage = (int) $request->query('per_page', 20);
        $perPage = max(1, min(100, $perPage));

        $feedback = BusinessFeedback::query()
            ->where('business_id', $business->id)
            ->where('moderation_status', BusinessFeedback::MODERATION_APPROVED)
            ->with([
                'user',
                'attachments',
                'responses.attachments',
                'responses.respondedBy',
            ])
            ->orderByDesc('created_at')
            ->paginate($perPage);

        return ApiResponse::success([
            'feedback' => BusinessFeedbackResource::collection($feedback->items()),
            'pagination' => [
                'current_page' => $feedback->currentPage(),
                'per_page' => $feedback->perPage(),
                'total' => $feedback->total(),
                'last_page' => $feedback->lastPage(),
            ],
        ]);
    }
}
