<?php

namespace App\Http\Controllers\Web;

use App\Http\Controllers\Controller;
use App\Models\Listing;
use App\Models\ListingCategory;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    /**
     * Display the web landing page.
     */
    public function index()
    {
        $categoriesPath = public_path('assets/categories.json');
        if (!file_exists($categoriesPath)) {
            $categories = [];
            $promotedListings = [];
            $recentListings = [];
            return view('web.home', compact('categories', 'promotedListings', 'recentListings'));
        }

        $categoriesJson = file_get_contents($categoriesPath);
        $categoriesData = json_decode($categoriesJson, true);

        // Group by parent
        $grouped = [];
        foreach ($categoriesData as $cat) {
            $grouped[$cat['parent']][] = $cat;
        }

        // Build hierarchy for top-level (parent = "0")
        $categories = [];
        if (isset($grouped["0"])) {
            foreach ($grouped["0"] as $parent) {
                $children = $grouped[$parent['id']] ?? [];
                
                // Map children to simplified structure
                $mappedChildren = array_map(function($child) {
                    return [
                        'id' => $child['id'],
                        'name' => $child['Category'],
                        'icon' => 'assets/' . $child['icon'],
                    ];
                }, $children);

                $categories[] = [
                    'id' => $parent['id'],
                    'name' => $parent['Category'],
                    'icon' => 'assets/' . $parent['icon'],
                    'children' => $mappedChildren
                ];
            }
        }

        $promotedListings = Listing::publicVisible()
            ->inRandomOrder()
            ->with(['media', 'business', 'createdBy'])
            ->take(30)
            ->get();

        $recentListings = Listing::publicVisible()
            ->latest()
            ->with(['media', 'business', 'createdBy'])
            ->take(12)
            ->get();

        // Load popular searches
        $popularSearches = \App\Models\SearchQuery::select('query')
            ->selectRaw('count(*) as count')
            ->whereNotNull('query')
            ->groupBy('query')
            ->orderByDesc('count')
            ->limit(5)
            ->pluck('query')
            ->all();

        return view('web.home', compact('categories', 'promotedListings', 'recentListings', 'popularSearches'));
    }
}
