<?php

namespace App\Http\Controllers;

use App\Models\PosOrder;
use Illuminate\Http\Request;

class WebReceiptController extends Controller
{
    /**
     * Verify a digital receipt via its unique UUID.
     *
     * @param string $uuid
     * @return \Illuminate\View\View
     */
    public function verify(string $uuid)
    {
        $order = PosOrder::where('offline_uuid', $uuid)
            ->with(['business', 'customer', 'cashier', 'payments'])
            ->firstOrFail();

        return view('web.receipt_verify', compact('order'));
    }
}
