<?php

namespace App\Http\Middleware;

use App\Http\Resources\ApiResponse;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckRole
{
    /**
     * Handle an incoming request.
     *
     * @param  string  ...$roles
     */
    public function handle(Request $request, Closure $next, string ...$roles): Response
    {
        $user = auth()->user();

        if (!$user) {
            if ($request->expectsJson() || $request->is('api/*')) {
                return ApiResponse::unauthorized('Authentication required.');
            }
            return redirect()->route('login')->with('error', 'Authentication required.');
        }

        if (!in_array($user->role, $roles)) {
            // Special case: if 'admin' is required, satisfy if user isAdmin() (covers super_admin)
            if (in_array(\App\Models\User::ROLE_ADMIN, $roles) && $user->isAdmin()) {
                // Allowed
            } else {
                if ($request->expectsJson() || $request->is('api/*')) {
                    return ApiResponse::forbidden('You do not have permission to access this resource.');
                }
                abort(403, 'You do not have permission to access this resource.');
            }
        }

        return $next($request);
    }
}
