<?php

namespace App\Http\Middleware;

use App\Http\Resources\ApiResponse;
use Closure;
use Illuminate\Http\Request;
use PHPOpenSourceSaver\JWTAuth\Exceptions\JWTException;
use PHPOpenSourceSaver\JWTAuth\Exceptions\TokenBlacklistedException;
use PHPOpenSourceSaver\JWTAuth\Exceptions\TokenExpiredException;
use PHPOpenSourceSaver\JWTAuth\Exceptions\TokenInvalidException;
use PHPOpenSourceSaver\JWTAuth\Facades\JWTAuth;
use Symfony\Component\HttpFoundation\Response;

class JwtAuthenticate
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next): Response
    {
        try {
            $user = JWTAuth::parseToken()->authenticate();

            if (!$user) {
                return ApiResponse::unauthorized('User not found.');
            }

            if (!$user->isActive()) {
                return ApiResponse::forbidden('Your account is not active.');
            }

            if ($user->isSuspended()) {
                return ApiResponse::forbidden('Your account has been suspended.');
            }

        } catch (TokenExpiredException $e) {
            return ApiResponse::unauthorized('Token has expired.');
        } catch (TokenInvalidException $e) {
            return ApiResponse::unauthorized('Token is invalid.');
        } catch (TokenBlacklistedException $e) {
            return ApiResponse::unauthorized('Token has been blacklisted.');
        } catch (JWTException $e) {
            return ApiResponse::unauthorized('Token not provided.');
        }

        return $next($request);
    }
}
