<?php

namespace App\Http\Requests\Admin;

use App\Models\User;
use Illuminate\Foundation\Http\FormRequest;

class UpdateUserRoleRequest extends FormRequest
{
    public function authorize(): bool
    {
        return $this->user()->isAdmin();
    }

    public function rules(): array
    {
        return [
            'role' => [
                'required',
                'string',
                'in:' . implode(',', [User::ROLE_USER, User::ROLE_SELLER, User::ROLE_ADMIN]),
            ],
        ];
    }
}
