<?php

namespace App\Http\Requests\Auth;

use Illuminate\Foundation\Http\FormRequest;

class LoginRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'login' => ['required', 'string', 'max:255'],
            'password' => ['required', 'string'],
        ];
    }

    public function messages(): array
    {
        return [
            'login.required' => 'Email or phone number is required.',
        ];
    }

    /**
     * Determine if the login field is an email or phone.
     */
    public function isEmail(): bool
    {
        return filter_var($this->login, FILTER_VALIDATE_EMAIL) !== false;
    }

    /**
     * Get the login field name.
     */
    public function loginField(): string
    {
        return $this->isEmail() ? 'email' : 'phone';
    }
}
