<?php

namespace App\Http\Requests\Auth;

use App\Models\User;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rules\Password;

class RegisterRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'full_name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email:rfc', 'max:255', 'unique:users,email'],
            'phone' => ['nullable', 'string', 'max:20', 'unique:users,phone', 'regex:/^\+?[1-9]\d{1,14}$/'],
            'password' => [
                'required',
                'string',
                'confirmed',
               Password::min(6)
                    ->uncompromised(),
            ],
            'date_of_birth' => ['nullable', 'date', 'before:today', 'after:1900-01-01'],
            'gender' => ['nullable', 'string', 'in:' . implode(',', [User::GENDER_MALE, User::GENDER_FEMALE, User::GENDER_OTHER])],
        ];
    }

    public function messages(): array
    {
        return [
            'phone.regex' => 'The phone number must be in E.164 format (e.g., +1234567890).',
            'password.uncompromised' => 'This password has appeared in a data breach. Please choose a different password.',
        ];
    }
}
