<?php

namespace App\Http\Requests\Auth;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rules\Password;

class ResetPasswordRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'token' => ['required', 'string'],
            'email' => ['required', 'string', 'email:rfc,dns', 'max:255', 'exists:users,email'],
            'password' => [
                'required',
                'string',
                'confirmed',
                Password::min(6)
                    ->uncompromised(),
            ],
        ];
    }
}
