<?php

namespace App\Http\Requests\Business;

use Illuminate\Foundation\Http\FormRequest;

class TransferBusinessOwnershipRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'new_owner_email' => ['required', 'email:rfc,dns', 'max:255', 'exists:users,email'],
        ];
    }
}
