<?php

namespace App\Http\Requests\Business;

use Illuminate\Foundation\Http\FormRequest;

class UpdateBusinessRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $phoneRegex = '/^\+?[1-9]\d{1,14}$/';

        return [
            'name' => ['sometimes', 'string', 'max:255'],
            'description' => ['sometimes', 'nullable', 'string', 'max:5000'],
            'business_type' => ['sometimes', 'nullable', 'string', 'max:100'],
            'business_category' => ['sometimes', 'nullable', 'string', 'max:100'],

            'address' => ['sometimes', 'nullable', 'string', 'max:255'],
            'district' => ['sometimes', 'nullable', 'string', 'max:100'],

            'website' => ['sometimes', 'nullable', 'url', 'max:255'],
            'facebook_url' => ['sometimes', 'nullable', 'url', 'max:255'],
            'instagram_url' => ['sometimes', 'nullable', 'url', 'max:255'],
            'x_url' => ['sometimes', 'nullable', 'url', 'max:255'],
            'linkedin_url' => ['sometimes', 'nullable', 'url', 'max:255'],
            'youtube_url' => ['sometimes', 'nullable', 'url', 'max:255'],
            'tiktok_url' => ['sometimes', 'nullable', 'url', 'max:255'],

            'logo' => ['sometimes', 'nullable', 'image', 'mimes:jpeg,jpg,png,gif,webp', 'max:5120'],
            'cover' => ['sometimes', 'nullable', 'image', 'mimes:jpeg,jpg,png,gif,webp', 'max:8192'],

            'primary_color' => ['sometimes', 'nullable', 'string', 'max:20'],
            'secondary_color' => ['sometimes', 'nullable', 'string', 'max:20'],

            'primary_phone' => ['sometimes', 'nullable', 'string', 'max:20', "regex:{$phoneRegex}"],
            'secondary_phone' => ['sometimes', 'nullable', 'string', 'max:20', "regex:{$phoneRegex}"],
            'primary_whatsapp' => ['sometimes', 'nullable', 'string', 'max:20', "regex:{$phoneRegex}"],
            'secondary_whatsapp' => ['sometimes', 'nullable', 'string', 'max:20', "regex:{$phoneRegex}"],

            'is_feedback_enabled' => ['sometimes', 'boolean'],
            'is_chat_enabled' => ['sometimes', 'boolean'],
            'allow_push_notifications' => ['sometimes', 'boolean'],
            'allow_email_notifications' => ['sometimes', 'boolean'],
            'allow_sms_notifications' => ['sometimes', 'boolean'],
        ];
    }
}
