<?php

namespace App\Http\Requests\Listing;

use Illuminate\Foundation\Http\FormRequest;

class GenerateListingContentRequest extends FormRequest
{
    public function authorize(): bool
    {
        return auth('api')->check();
    }

    public function rules(): array
    {
        return [
            'title' => ['required', 'string', 'min:3', 'max:200'],
            'category' => ['sometimes', 'nullable', 'string', 'max:100'],
            'additional_context' => ['sometimes', 'nullable', 'string', 'max:500'],
        ];
    }

    public function messages(): array
    {
        return [
            'title.required' => 'Please provide a product title',
            'title.min' => 'Title must be at least 3 characters',
            'title.max' => 'Title must not exceed 200 characters',
        ];
    }
}
