<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class BusinessFeedbackResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'business_id' => $this->business_id,
            'user_id' => $this->user_id,
            'user' => $this->whenLoaded('user', fn () => new UserResource($this->user)),
            'message' => $this->message,
            'sentiment' => $this->sentiment,
            'moderation_status' => $this->moderation_status,
            'reviewed_by_user_id' => $this->reviewed_by_user_id,
            'reviewed_at' => $this->reviewed_at?->toIso8601String(),
            'moderation_notes' => $this->moderation_notes,
            'attachments' => BusinessFeedbackAttachmentResource::collection($this->whenLoaded('attachments')),
            'responses' => BusinessFeedbackResponseResource::collection($this->whenLoaded('responses')),
            'created_at' => $this->created_at?->toIso8601String(),
            'updated_at' => $this->updated_at?->toIso8601String(),
        ];
    }
}
