<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class BusinessResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        $authUser = null;
        try {
            $authUser = auth('api')->user();
        } catch (\Throwable $e) {
            $authUser = null;
        }

        $isFollowing = false;
        if ($authUser) {
            $isFollowing = (bool) ($this->is_following ?? $this->followers()->where('users.id', $authUser->id)->exists());
        }

        $activeSubscription = $this->activeSubscription();

        return [
            'id' => $this->id,
            'owner_user_id' => $this->owner_user_id,

            'name' => $this->name,
            'description' => $this->description,
            'business_type' => $this->business_type,
            'business_category' => $this->business_category,
            'slug' => $this->slug,

            'address' => $this->address,
            'district' => $this->district,

            'website' => $this->website,
            'facebook_url' => $this->facebook_url,
            'instagram_url' => $this->instagram_url,
            'x_url' => $this->x_url,
            'linkedin_url' => $this->linkedin_url,
            'youtube_url' => $this->youtube_url,
            'tiktok_url' => $this->tiktok_url,

            'logo_url' => $this->logo_url,
            'cover_url' => $this->cover_url,
            'primary_color' => $this->primary_color,
            'secondary_color' => $this->secondary_color,

            'primary_phone' => $this->primary_phone,
            'secondary_phone' => $this->secondary_phone,
            'primary_whatsapp' => $this->primary_whatsapp,
            'secondary_whatsapp' => $this->secondary_whatsapp,

            'contact_verification' => [
                'is_primary_phone_verified' => (bool) $this->is_primary_phone_verified,
                'primary_phone_verified_at' => $this->primary_phone_verified_at?->toIso8601String(),
                'is_secondary_phone_verified' => (bool) $this->is_secondary_phone_verified,
                'secondary_phone_verified_at' => $this->secondary_phone_verified_at?->toIso8601String(),
                'is_primary_whatsapp_verified' => (bool) $this->is_primary_whatsapp_verified,
                'primary_whatsapp_verified_at' => $this->primary_whatsapp_verified_at?->toIso8601String(),
                'is_secondary_whatsapp_verified' => (bool) $this->is_secondary_whatsapp_verified,
                'secondary_whatsapp_verified_at' => $this->secondary_whatsapp_verified_at?->toIso8601String(),
            ],

            'is_feedback_enabled' => (bool) $this->is_feedback_enabled,
            'is_chat_enabled' => (bool) $this->is_chat_enabled,
            'allow_push_notifications' => (bool) $this->allow_push_notifications,
            'allow_email_notifications' => (bool) $this->allow_email_notifications,
            'allow_sms_notifications' => (bool) $this->allow_sms_notifications,

            'verification_status' => $this->verification_status,
            'verification_requested_at' => $this->verification_requested_at?->toIso8601String(),
            'verified_at' => $this->verified_at?->toIso8601String(),
            'verified_by_user_id' => $this->verified_by_user_id,
            'verification_notes' => $this->verification_notes,

            'followers_count' => (int) ($this->followers_count ?? 0),
            'listings_count' => (int) ($this->listings_count ?? 0),
            'is_following' => $isFollowing,

            'created_at' => $this->created_at?->toIso8601String(),
            'updated_at' => $this->updated_at?->toIso8601String(),

            'subscription' => $activeSubscription ? [
                'id' => $activeSubscription->id,
                'package_id' => $activeSubscription->package_id,
                'package_name' => $activeSubscription->package?->name,
                'status' => $activeSubscription->status,
                'expires_at' => $activeSubscription->expires_at?->toIso8601String(),
                'listings_used' => $activeSubscription->listings_used,
                'max_listings' => $activeSubscription->package?->max_listings,
                'verified_badge' => (bool) $activeSubscription->package?->verified_badge,
                'analytics_access' => (bool) $activeSubscription->package?->analytics_access,
                'remove_ads' => (bool) $activeSubscription->package?->remove_ads,
            ] : null,
        ];
    }
}
