<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ListingResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'is_verified_seller' => $this->business ? $this->business->isVerifiedMember() : false,
            'promoted_rank' => $this->promoted_rank,
            'business_id' => $this->business_id,
            'created_by_user_id' => $this->created_by_user_id,
            'category' => $this->category,
            'sub_category' => $this->sub_category,
            'sub_sub_category' => $this->sub_sub_category,

            'title' => $this->title,
            'slug' => $this->slug,
            'description' => $this->description,

            'price' => [
                'amount' => $this->price_amount,
                'purchase_amount' => $this->purchase_price_amount,
                'currency' => $this->currency,
            ],
            'status' => $this->status,
            'decline_reason' => $this->decline_reason,

            'inventory' => [
                'quantity' => (int) $this->quantity,
                'sku' => $this->sku,
                'barcode' => $this->barcode,
                'allow_pos' => (bool) $this->allow_pos,
            ],

            'location' => [
                'country_code' => $this->location_country_code,
                'city' => $this->location_city,
                'district' => $this->location_district,
                'latitude' => $this->latitude,
                'longitude' => $this->longitude,
            ],

            'attributes' => $this->attributes,
            'custom_fields' => $this->custom_fields,

            'seo' => [
                'meta_title' => $this->meta_title,
                'meta_description' => $this->meta_description,
                'meta_keywords' => $this->meta_keywords,
                'canonical_url' => $this->canonical_url,
            ],

            'timing' => [
                'created_at' => $this->created_at?->toIso8601String(),
                'updated_at' => $this->updated_at?->toIso8601String(),
                'published_at' => $this->published_at?->toIso8601String(),
                'bumped_at' => $this->bumped_at?->toIso8601String(),
                'promoted_until' => $this->promoted_until?->toIso8601String(),
                'expires_at' => $this->expires_at?->toIso8601String(),
            ],

            'stats' => [
                'views_count' => $this->views_count ?? 0,
                'unique_views_count' => $this->unique_views_count ?? 0,
                'impressions_count' => $this->impressions_count ?? 0,
                'clicks_count' => $this->clicks_count ?? 0,
                'phone_reveals_count' => $this->phone_reveals_count ?? 0,
                'whatsapp_clicks_count' => $this->whatsapp_clicks_count ?? 0,
                'shares_count' => $this->shares_count ?? 0,
            ],

            'business' => $this->business 
                ? new BusinessResource($this->business)
                : ($this->createdBy ? [
                    'id' => $this->createdBy->id, // Use User ID as Business ID fallback or keep null? Better to indicate it's a user. But client expects Business ID. Let's use user ID but usually IDs shouldn't mix. 
                    // Wait, if I explicitly map, I should try to mimic the structure.
                    'owner_user_id' => $this->createdBy->id,
                    'name' => $this->createdBy->full_name ?? $this->createdBy->username,
                    'description' => $this->createdBy->bio,
                    'business_type' => 'Individual',
                    'business_category' => null,
                    'slug' => $this->createdBy->username, // Fallback slug
                    'address' => $this->createdBy->full_location, // Approximate
                    'district' => $this->createdBy->district,
                    'website' => $this->createdBy->website,
                    'facebook_url' => $this->createdBy->facebook_url,
                    'instagram_url' => $this->createdBy->instagram_url,
                    'x_url' => $this->createdBy->twitter_url,
                    'linkedin_url' => $this->createdBy->linkedin_url,
                    'youtube_url' => $this->createdBy->youtube_url,
                    'tiktok_url' => $this->createdBy->tiktok_url,
                    'logo_url' => $this->createdBy->profile_photo_url,
                    'cover_url' => null,
                    'primary_color' => null,
                    'secondary_color' => null,
                    'primary_phone' => $this->createdBy->phone,
                    'secondary_phone' => $this->createdBy->secondary_phone,
                    'primary_whatsapp' => $this->createdBy->whatsapp_number,
                    'secondary_whatsapp' => $this->createdBy->secondary_whatsapp_number,
                    'contact_verification' => [
                         'is_primary_phone_verified' => (bool)$this->createdBy->is_phone_verified,
                         'primary_phone_verified_at' => null, // Data not strictly available on User model root usually
                         'is_secondary_phone_verified' => false,
                         'secondary_phone_verified_at' => null,
                         'is_primary_whatsapp_verified' => false,
                         'primary_whatsapp_verified_at' => null,
                         'is_secondary_whatsapp_verified' => false,
                         'secondary_whatsapp_verified_at' => null,
                    ],
                    'is_feedback_enabled' => true,
                    'is_chat_enabled' => true,
                    'allow_push_notifications' => true,
                    'allow_email_notifications' => true,
                    'allow_sms_notifications' => true,
                    'verification_status' => $this->createdBy->identity_verification_status ?? 'unverified',
                    'verification_requested_at' => null,
                    'verified_at' => null,
                    'verified_by_user_id' => null,
                    'verification_notes' => null,
                    'followers_count' => 0,
                    'listings_count' => 0, // Could count loaded listings if available
                    'is_following' => false,
                    'created_at' => $this->createdBy->created_at?->toIso8601String(),
                    'updated_at' => $this->createdBy->updated_at?->toIso8601String(),
                ] : null),
            'media' => ListingMediaResource::collection($this->whenLoaded('media')),
            'tags' => $this->tags,

            'created_at' => $this->created_at?->toIso8601String(),
            'updated_at' => $this->updated_at?->toIso8601String(),
            'deleted_at' => $this->deleted_at?->toIso8601String(),
        ];
    }
}
