<?php

namespace App\Mail;

use App\Models\Business;
use App\Models\BusinessInvitation;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class BusinessInvitationRevokedEmail extends Mailable
{
    use Queueable, SerializesModels;

    public function __construct(
        public Business $business,
        public BusinessInvitation $invite
    ) {
    }

    public function envelope(): Envelope
    {
        return new Envelope(
            subject: "Invitation revoked: {$this->business->name}",
        );
    }

    public function content(): Content
    {
        return new Content(
            html: 'emails.business-invitation-revoked',
        );
    }

    public function attachments(): array
    {
        return [];
    }
}
