<?php

namespace App\Mail;

use App\Models\Business;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class BusinessOwnershipTransferredOldOwnerEmail extends Mailable
{
    use Queueable, SerializesModels;

    public function __construct(
        public Business $business,
        public User $previousOwner,
        public User $newOwner,
        public User $actor
    ) {
    }

    public function envelope(): Envelope
    {
        return new Envelope(
            subject: "Ownership transferred: {$this->business->name}",
        );
    }

    public function content(): Content
    {
        return new Content(
            html: 'emails.business-ownership-transferred-old-owner',
        );
    }

    public function attachments(): array
    {
        return [];
    }
}
