<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Ad extends Model
{
    protected $fillable = [
        'headline',
        'description',
        'display_url',
        'destination_url',
        'placement',
        'status',
        'views_count',
        'clicks_count',
        'impressions_count',
    ];

    public function sitelinks(): HasMany
    {
        return $this->hasMany(AdSitelink::class);
    }

    public function trackings(): HasMany
    {
        return $this->hasMany(AdTracking::class);
    }
}
