<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class BusinessFeedback extends Model
{
    public const SENTIMENT_NEGATIVE = 'negative';
    public const SENTIMENT_NEUTRAL = 'neutral';
    public const SENTIMENT_POSITIVE = 'positive';

    public const MODERATION_PENDING = 'pending';
    public const MODERATION_APPROVED = 'approved';
    public const MODERATION_REJECTED = 'rejected';

    protected $table = 'business_feedbacks';

    protected $fillable = [
        'business_id',
        'user_id',
        'message',
        'sentiment',
        'moderation_status',
        'reviewed_by_user_id',
        'reviewed_at',
        'moderation_notes',
    ];

    protected function casts(): array
    {
        return [
            'reviewed_at' => 'datetime',
        ];
    }

    public function business(): BelongsTo
    {
        return $this->belongsTo(Business::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function reviewedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'reviewed_by_user_id');
    }

    public function responses(): HasMany
    {
        return $this->hasMany(BusinessFeedbackResponse::class);
    }

    public function attachments(): HasMany
    {
        return $this->hasMany(BusinessFeedbackAttachment::class);
    }
}
