<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class BusinessFeedbackResponse extends Model
{
    protected $fillable = [
        'business_feedback_id',
        'business_id',
        'responded_by_user_id',
        'message',
    ];

    public function feedback(): BelongsTo
    {
        return $this->belongsTo(BusinessFeedback::class, 'business_feedback_id');
    }

    public function business(): BelongsTo
    {
        return $this->belongsTo(Business::class);
    }

    public function respondedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'responded_by_user_id');
    }

    public function attachments(): HasMany
    {
        return $this->hasMany(BusinessFeedbackAttachment::class, 'business_feedback_response_id');
    }
}
