<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InventoryReport extends Model
{
    use HasFactory;

    protected $fillable = [
        'business_id',
        'summary',
        'anomalies',
        'ai_insights',
    ];

    protected $casts = [
        'summary' => 'array',
        'anomalies' => 'array',
    ];

    public function business()
    {
        return $this->belongsTo(Business::class);
    }
}
