<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ListingClick extends Model
{
    protected $fillable = [
        'listing_id',
        'user_id',
        'source',
        'ip_address',
        'session_id',
        'context',
        'clicked_at',
    ];

    protected function casts(): array
    {
        return [
            'context' => 'array',
            'clicked_at' => 'datetime',
        ];
    }

    public function listing(): BelongsTo
    {
        return $this->belongsTo(Listing::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
