<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Facades\Storage;

class ListingMedia extends Model
{
    public const TYPE_IMAGE = 'image';
    public const TYPE_VIDEO = 'video';

    protected $table = 'listing_media';

    protected $fillable = [
        'listing_id',
        'uploaded_by_user_id',
        'path',
        'watermarked_path',
        'tags',
        'mime_type',
        'size_bytes',
        'content_hash',
        'type',
        'sort_order',
        'is_primary',
    ];

    protected function casts(): array
    {
        return [
            'tags' => 'array',
            'size_bytes' => 'integer',
            'sort_order' => 'integer',
            'is_primary' => 'boolean',
        ];
    }

    public function listing(): BelongsTo
    {
        return $this->belongsTo(Listing::class);
    }

    public function uploadedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uploaded_by_user_id');
    }

    public function getUrlAttribute(): ?string
    {
        if (!$this->path) {
            return null;
        }

        if (filter_var($this->path, FILTER_VALIDATE_URL)) {
            return $this->path;
        }

        return Storage::disk('public')->url($this->path);
    }

    public function getWatermarkedUrlAttribute(): ?string
    {
        if (!$this->watermarked_path) {
            return null;
        }

        if (filter_var($this->watermarked_path, FILTER_VALIDATE_URL)) {
            return $this->watermarked_path;
        }

        return Storage::disk('public')->url($this->watermarked_path);
    }
}
