<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PosExpense extends Model
{
    protected $fillable = [
        'business_id',
        'pos_shift_id',
        'user_id',
        'amount',
        'reason',
        'category',
        'payment_method',
        'expense_date',
    ];

    protected $casts = [
        'amount' => 'float',
        'expense_date' => 'datetime',
    ];

    public function business(): BelongsTo
    {
        return $this->belongsTo(Business::class);
    }

    public function shift(): BelongsTo
    {
        return $this->belongsTo(PosShift::class, 'pos_shift_id');
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
