<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class PremiumPackage extends Model
{
    protected $fillable = [
        'name',
        'slug',
        'color',
        'description',
        'price',
        'currency',
        'duration_days',
        'max_listings',
        'max_featured_listings',
        'max_bumps_per_month',
        'auto_bump_enabled',
        'auto_bump_interval_hours',
        'max_images_per_listing',
        'priority_support',
        'verified_badge',
        'analytics_access',
        'remove_ads',
        'is_active',
        'sort_order',
        'features',
    ];

    protected $casts = [
        'price' => 'decimal:2',
        'duration_days' => 'integer',
        'max_listings' => 'integer',
        'max_featured_listings' => 'integer',
        'max_bumps_per_month' => 'integer',
        'max_images_per_listing' => 'integer',
        'priority_support' => 'boolean',
        'verified_badge' => 'boolean',
        'analytics_access' => 'boolean',
        'remove_ads' => 'boolean',
        'is_active' => 'boolean',
        'sort_order' => 'integer',
        'features' => 'array',
    ];

    public function subscriptions(): HasMany
    {
        return $this->hasMany(UserSubscription::class, 'package_id');
    }
}
