<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class SearchQuery extends Model
{
    protected $fillable = [
        'user_id',
        'search_type',
        'query',
        'filters',
        'results_count',
        'ip_address',
        'user_agent',
        'session_id',
        'searched_at',
    ];

    protected $casts = [
        'filters' => 'array',
        'searched_at' => 'datetime',
        'results_count' => 'integer',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
