<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;
use App\Services\FcmService;

class GeneralNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public $title;
    public $body;
    public $data;
    public $sendFcm;

    public function __construct(string $title, string $body, array $data = [], bool $sendFcm = false)
    {
        $this->title = $title;
        $this->body = $body;
        $this->data = $data;
        $this->sendFcm = $sendFcm;
    }

    public function via($notifiable)
    {
        return ['database'];
    }

    public function toArray($notifiable)
    {
        // Trigger FCM if enabled
        if ($this->sendFcm && $notifiable->id) {
            try {
                app(FcmService::class)->sendToUser(
                    $notifiable->id,
                    $this->title,
                    $this->body,
                    $this->data
                );
            } catch (\Throwable $e) {
                \Log::warning('Failed to send FCM notification', [
                    'user_id' => $notifiable->id,
                    'error' => $e->getMessage(),
                ]);
            }
        }

        return [
            'title' => $this->title,
            'body' => $this->body,
            'data' => $this->data,
        ];
    }
}
