<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('secondary_whatsapp_number', 20)->nullable()->after('whatsapp_number');

            $table->timestamp('secondary_phone_verified_at')->nullable()->after('secondary_phone');
            $table->timestamp('whatsapp_verified_at')->nullable()->after('whatsapp_number');
            $table->timestamp('secondary_whatsapp_verified_at')->nullable()->after('secondary_whatsapp_number');
        });
    }

    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'secondary_whatsapp_number',
                'secondary_phone_verified_at',
                'whatsapp_verified_at',
                'secondary_whatsapp_verified_at',
            ]);
        });
    }
};
