<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('businesses', function (Blueprint $table) {
            $table->boolean('is_primary_phone_verified')->default(false);
            $table->timestamp('primary_phone_verified_at')->nullable();

            $table->boolean('is_secondary_phone_verified')->default(false);
            $table->timestamp('secondary_phone_verified_at')->nullable();

            $table->boolean('is_primary_whatsapp_verified')->default(false);
            $table->timestamp('primary_whatsapp_verified_at')->nullable();

            $table->boolean('is_secondary_whatsapp_verified')->default(false);
            $table->timestamp('secondary_whatsapp_verified_at')->nullable();
        });
    }

    public function down(): void
    {
        Schema::table('businesses', function (Blueprint $table) {
            $table->dropColumn([
                'is_primary_phone_verified',
                'primary_phone_verified_at',
                'is_secondary_phone_verified',
                'secondary_phone_verified_at',
                'is_primary_whatsapp_verified',
                'primary_whatsapp_verified_at',
                'is_secondary_whatsapp_verified',
                'secondary_whatsapp_verified_at',
            ]);
        });
    }
};
