<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('business_feedback_attachments')) {
            Schema::create('business_feedback_attachments', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('business_feedback_id')->nullable();
                $table->unsignedBigInteger('business_feedback_response_id')->nullable();

                $table->string('path');
                $table->string('mime_type')->nullable();
                $table->unsignedBigInteger('size_bytes')->nullable();

                $table->timestamps();
            });
        }

        $hasForeignKey = function (string $constraintName): bool {
            $row = DB::selectOne(
                "SELECT 1 FROM information_schema.TABLE_CONSTRAINTS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'business_feedback_attachments' AND CONSTRAINT_NAME = ? AND CONSTRAINT_TYPE = 'FOREIGN KEY' LIMIT 1",
                [$constraintName]
            );

            return $row !== null;
        };

        $hasIndex = function (string $indexName): bool {
            $row = DB::selectOne(
                "SELECT 1 FROM information_schema.STATISTICS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'business_feedback_attachments' AND INDEX_NAME = ? LIMIT 1",
                [$indexName]
            );

            return $row !== null;
        };

        if (!$hasForeignKey('bfa_feedback_fk')) {
            Schema::table('business_feedback_attachments', function (Blueprint $table) {
                $table->foreign('business_feedback_id', 'bfa_feedback_fk')
                    ->references('id')
                    ->on('business_feedbacks')
                    ->onDelete('cascade');
            });
        }

        if (!$hasForeignKey('bfa_response_fk')) {
            Schema::table('business_feedback_attachments', function (Blueprint $table) {
                $table->foreign('business_feedback_response_id', 'bfa_response_fk')
                    ->references('id')
                    ->on('business_feedback_responses')
                    ->onDelete('cascade');
            });
        }

        if (!$hasIndex('bfa_feedback_idx')) {
            Schema::table('business_feedback_attachments', function (Blueprint $table) {
                $table->index(['business_feedback_id'], 'bfa_feedback_idx');
            });
        }

        if (!$hasIndex('bfa_response_idx')) {
            Schema::table('business_feedback_attachments', function (Blueprint $table) {
                $table->index(['business_feedback_response_id'], 'bfa_response_idx');
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('business_feedback_attachments');
    }
};
