<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('listings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('business_id')->constrained('businesses')->onDelete('cascade');
            $table->foreignId('created_by_user_id')->nullable()->constrained('users')->nullOnDelete();
            $table->string('category')->nullable();
            $table->string('sub_category')->nullable();
            $table->string('sub_sub_category')->nullable();

            $table->string('title');
            $table->string('slug')->unique();
            $table->text('description');

            $table->decimal('price_amount', 12, 2)->nullable();
            $table->decimal('purchase_price_amount', 12, 2)->nullable();
            $table->string('currency', 3)->default('UGX');

            $table->enum('status', ['draft', 'published', 'review', 'rejected', 'sold', 'expired'])->default('draft');
            $table->string('decline_reason')->nullable();

            $table->unsignedInteger('quantity')->default(1);
            $table->string('sku')->nullable();
            $table->string('barcode')->nullable();
            $table->boolean('allow_pos')->default(false);

            $table->string('location_country_code', 2)->nullable();
            $table->string('location_city')->nullable();
            $table->string('location_district')->nullable();
            $table->decimal('latitude', 10, 7)->nullable();
            $table->decimal('longitude', 10, 7)->nullable();

            $table->json('attributes')->nullable();
            $table->json('custom_fields')->nullable();
            $table->json('tags')->nullable();

            $table->string('meta_title')->nullable();
            $table->string('meta_description')->nullable();
            $table->string('meta_keywords')->nullable();
            $table->string('canonical_url')->nullable();

            $table->timestamp('published_at')->nullable();
            $table->timestamp('bumped_at')->nullable();
            $table->timestamp('promoted_until')->nullable();
            $table->unsignedInteger('promoted_rank')->default(0);
            $table->timestamp('expires_at')->nullable();

            $table->unsignedBigInteger('views_count')->default(0);

            $table->timestamps();
            $table->softDeletes();

            $table->index(['business_id', 'status'], 'l_business_status_idx');
            $table->index(['category', 'sub_category', 'sub_sub_category'], 'l_cat_tree_idx');
            $table->index(['status', 'promoted_until'], 'l_status_promo_idx');
            $table->index(['status', 'bumped_at'], 'l_status_bump_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('listings');
    }
};
