<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('listing_media', function (Blueprint $table) {
            $table->id();
            $table->foreignId('listing_id')->nullable()->constrained('listings')->onDelete('cascade');
            $table->foreignId('uploaded_by_user_id')->nullable()->constrained('users')->nullOnDelete();
            $table->string('path');
            $table->string('watermarked_path')->nullable();
            $table->json('tags')->nullable();
            $table->string('mime_type')->nullable();
            $table->unsignedBigInteger('size_bytes')->nullable();
            $table->string('content_hash', 64)->nullable();
            $table->enum('type', ['image', 'video'])->default('image');
            $table->unsignedInteger('sort_order')->default(0);
            $table->boolean('is_primary')->default(false);
            $table->timestamps();

            $table->index(['listing_id', 'sort_order'], 'lm_listing_sort_idx');
            $table->index(['listing_id', 'content_hash'], 'lm_listing_hash_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('listing_media');
    }
};
