<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('listings')) {
            return;
        }

        if (!Schema::hasColumn('listings', 'condition')) {
            return;
        }

        Schema::table('listings', function (Blueprint $table) {
            $table->dropColumn('condition');
        });
    }

    public function down(): void
    {
        if (!Schema::hasTable('listings')) {
            return;
        }

        if (Schema::hasColumn('listings', 'condition')) {
            return;
        }

        Schema::table('listings', function (Blueprint $table) {
            $table->enum('condition', ['new', 'used', 'refurbished'])->default('used')->after('currency');
        });
    }
};
