<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('listing_media')) {
            return;
        }

        // Make listing_id nullable to support pre-upload
        DB::statement('ALTER TABLE listing_media MODIFY listing_id BIGINT UNSIGNED NULL');

        Schema::table('listing_media', function (Blueprint $table) {
            if (!Schema::hasColumn('listing_media', 'uploaded_by_user_id')) {
                $table->foreignId('uploaded_by_user_id')->nullable()->after('listing_id')->constrained('users')->nullOnDelete();
            }
        });
    }

    public function down(): void
    {
        if (!Schema::hasTable('listing_media')) {
            return;
        }

        Schema::table('listing_media', function (Blueprint $table) {
            if (Schema::hasColumn('listing_media', 'uploaded_by_user_id')) {
                $table->dropForeign(['uploaded_by_user_id']);
                $table->dropColumn('uploaded_by_user_id');
            }
        });

        // Make listing_id NOT NULL again
        DB::statement('ALTER TABLE listing_media MODIFY listing_id BIGINT UNSIGNED NOT NULL');
    }
};
