<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('listing_media')) {
            return;
        }

        Schema::table('listing_media', function (Blueprint $table) {
            if (!Schema::hasColumn('listing_media', 'watermarked_path')) {
                $table->string('watermarked_path')->nullable()->after('path');
            }
        });
    }

    public function down(): void
    {
        if (!Schema::hasTable('listing_media')) {
            return;
        }

        Schema::table('listing_media', function (Blueprint $table) {
            if (Schema::hasColumn('listing_media', 'watermarked_path')) {
                $table->dropColumn('watermarked_path');
            }
        });
    }
};
