<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('listing_media')) {
            return;
        }

        Schema::table('listing_media', function (Blueprint $table) {
            if (!Schema::hasColumn('listing_media', 'tags')) {
                $table->json('tags')->nullable()->after('watermarked_path');
            }
        });
    }

    public function down(): void
    {
        if (!Schema::hasTable('listing_media')) {
            return;
        }

        Schema::table('listing_media', function (Blueprint $table) {
            if (Schema::hasColumn('listing_media', 'tags')) {
                $table->dropColumn('tags');
            }
        });
    }
};
