<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('listing_views', function (Blueprint $table) {
            $table->id();
            $table->foreignId('listing_id')->constrained('listings')->onDelete('cascade');
            $table->foreignId('user_id')->nullable()->constrained('users')->nullOnDelete();
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();
            $table->string('session_id')->nullable();
            $table->timestamp('viewed_at');
            $table->timestamps();

            // Indexes for performance
            $table->index(['listing_id', 'viewed_at']);
            $table->index(['user_id', 'viewed_at']);
            $table->index(['listing_id', 'user_id']);
            $table->index(['listing_id', 'session_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('listing_views');
    }
};
