<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('listings')) {
            return;
        }

        Schema::table('listings', function (Blueprint $table) {
            if (!Schema::hasColumn('listings', 'views_count')) {
                $table->unsignedBigInteger('views_count')->default(0)->after('bumped_at');
            }
            if (!Schema::hasColumn('listings', 'unique_views_count')) {
                $table->unsignedBigInteger('unique_views_count')->default(0)->after('views_count');
            }
        });
    }

    public function down(): void
    {
        if (!Schema::hasTable('listings')) {
            return;
        }

        Schema::table('listings', function (Blueprint $table) {
            if (Schema::hasColumn('listings', 'views_count')) {
                $table->dropColumn('views_count');
            }
            if (Schema::hasColumn('listings', 'unique_views_count')) {
                $table->dropColumn('unique_views_count');
            }
        });
    }
};
