<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('listing_impressions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('listing_id')->constrained('listings')->onDelete('cascade');
            $table->foreignId('user_id')->nullable()->constrained('users')->nullOnDelete();
            $table->string('source')->nullable(); // 'feed', 'search', 'category', 'related', 'business_profile'
            $table->string('ip_address', 45)->nullable();
            $table->string('session_id')->nullable();
            $table->json('context')->nullable(); // search query, filters, position in feed, etc.
            $table->timestamp('impressed_at');
            $table->timestamps();

            // Indexes for analytics queries
            $table->index(['listing_id', 'impressed_at']);
            $table->index(['listing_id', 'source']);
            $table->index(['user_id', 'impressed_at']);
            $table->index('impressed_at');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('listing_impressions');
    }
};
