<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('listing_clicks', function (Blueprint $table) {
            $table->id();
            $table->foreignId('listing_id')->constrained('listings')->onDelete('cascade');
            $table->foreignId('user_id')->nullable()->constrained('users')->nullOnDelete();
            $table->string('source')->nullable(); // 'feed', 'search', 'category', 'related'
            $table->string('ip_address', 45)->nullable();
            $table->string('session_id')->nullable();
            $table->json('context')->nullable(); // search query, position clicked, etc.
            $table->timestamp('clicked_at');
            $table->timestamps();

            // Indexes
            $table->index(['listing_id', 'clicked_at']);
            $table->index(['listing_id', 'source']);
            $table->index(['user_id', 'clicked_at']);
            $table->index('clicked_at');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('listing_clicks');
    }
};
