<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('listing_interactions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('listing_id')->constrained('listings')->onDelete('cascade');
            $table->foreignId('user_id')->nullable()->constrained('users')->nullOnDelete();
            $table->string('interaction_type'); // 'phone_reveal', 'whatsapp_click', 'email_click', 'share', 'favorite', 'report'
            $table->string('ip_address', 45)->nullable();
            $table->string('session_id')->nullable();
            $table->json('metadata')->nullable(); // Additional context
            $table->timestamp('interacted_at');
            $table->timestamps();

            // Indexes
            $table->index(['listing_id', 'interaction_type']);
            $table->index(['listing_id', 'interacted_at']);
            $table->index('interaction_type');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('listing_interactions');
    }
};
