<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('premium_packages', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('slug')->unique();
            $table->text('description')->nullable();
            $table->decimal('price', 10, 2);
            $table->string('currency', 3)->default('KES');
            $table->integer('duration_days');
            $table->integer('max_listings')->default(0);
            $table->integer('max_featured_listings')->default(0);
            $table->integer('max_bumps_per_month')->default(0);
            $table->integer('max_images_per_listing')->default(5);
            $table->boolean('priority_support')->default(false);
            $table->boolean('verified_badge')->default(false);
            $table->boolean('analytics_access')->default(false);
            $table->boolean('remove_ads')->default(false);
            $table->boolean('is_active')->default(true);
            $table->integer('sort_order')->default(0);
            $table->json('features')->nullable();
            $table->timestamps();
            
            $table->index('slug');
            $table->index('is_active');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('premium_packages');
    }
};
