<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('premium_packages', function (Blueprint $table) {
            $table->boolean('auto_bump_enabled')->default(false)->after('max_bumps_per_month');
            $table->integer('auto_bump_interval_hours')->default(24)->after('auto_bump_enabled');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('premium_packages', function (Blueprint $table) {
            $table->dropColumn(['auto_bump_enabled', 'auto_bump_interval_hours']);
        });
    }
};
