<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasColumn('users', 'v1_salt')) {
            Schema::table('users', function (Blueprint $table) {
                $table->string('v1_salt')->nullable();
                $table->string('v1_password_hash')->nullable();
            });
        }
    }

    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['v1_salt', 'v1_password_hash']);
        });
    }
};
