<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;

class AdminSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        User::create([
            'full_name' => 'System Administrator',
            'username' => 'admin',
            'email' => 'admin@yilick.com',
            'phone' => '+1000000000',
            'password' => 'Admin@123456',
            'status' => User::STATUS_ACTIVE,
            'role' => User::ROLE_SUPER_ADMIN,
            'email_verified_at' => now(),
            'phone_verified_at' => now(),
            'is_email_verified' => true,
            'is_phone_verified' => true,
            'identity_verification_status' => User::IDENTITY_VERIFIED,
            'identity_verified_at' => now(),
            'country' => 'United States',
            'country_code' => 'US',
            'language' => 'en',
            'currency' => 'USD',
            'timezone' => 'America/New_York',
        ]);

        $this->command->info('Super Admin user created: admin@yilick.com / Admin@123456');
    }
}
