<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class BlogSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Clear existing posts
        \App\Models\BlogPost::truncate();

        // 1. Visionary Featured Post
        \App\Models\BlogPost::create([
            'title' => 'Empowering Uganda\'s Local Commerce: The Yilick Vision',
            'slug' => 'empowering-uganda-local-commerce-vision',
            'excerpt' => 'At Yilick, we are not just building another marketplace; we are constructing a digital foundation where every Ugandan entrepreneur can thrive using AI and integrated trust systems.',
            'content' => <<<EOD
Digital commerce in Uganda is at a crossroads. For years, small-scale merchants have relied on fragmented platforms and social media groups to sell their goods, often facing challenges with trust, visibility, and business management. Yilick was born from a simple yet powerful idea: what if a local shop in Ntinda or a boutique in Mbarara could have access to the same high-level business tools as a global retail giant?

### The Core Problem: Fragmentation and Fear
Traditional online trade in our region is often plagued by uncertainty. Buyers fear losing their money to anonymous sellers, while sellers worry about payment defaults or the lack of professional digital presence. Social media platforms, while great for connecting, were never built to handle high-volume commerce, secure payments, or inventory management. This fragmentation holds back the potential of millions of Ugandan entrepreneurs.

### Our Solution: A Structured Ecosystem
Our platform is designed to bridge this gap by offering more than just a listing space. We provide a structured ecosystem that handles the heavy lifting of modern business. By integrating Artificial Intelligence into our search and inventory systems, we provide merchants with real-time insights into what buyers are searching for. This means you aren't just selling; you are strategically meeting market demand.

### Standardizing Trust with SafeTrade
But a marketplace is only as strong as its trust. That is why we introduced the SafeTrade Escrow system, ensuring that every transaction—from a used iPhone to a new property—is protected until both parties are satisfied. We believe that by standardizing trust, we can unlock billions of shillings in previously untapped digital trade.

### The Road Ahead: Empowering the People
We believe that the future of trade in Africa isn't just about moving products from point A to point B; it’s about empowering the people behind the products. Yilick is your partner in this journey, providing a professional, branded space that turns casual browsers into loyal customers. We are committed to continuous innovation, ensuring that as technology evolves, our merchants are always ahead of the curve.
EOD,
            'category' => 'Success Stories',
            'author' => 'Xperbyte Team',
            'read_time' => 12,
            'is_featured' => true,
            'is_published' => true,
            'published_at' => now(),
        ]);

        // 2. Data/Merchant Focus
        \App\Models\BlogPost::create([
            'title' => 'AI-Powered Insights: How Yilick Analytics are Transforming Small Shops',
            'slug' => 'ai-powered-insights-transforming-shops',
            'excerpt' => 'Data is the new oil, but for many small businesses, it has been inaccessible. Yilick is changing that by giving every seller a professional analytics dashboard.',
            'content' => <<<EOD
In a traditional marketplace, a seller might know which product is selling, but they rarely know *why*. On Yilick, we give you the "why." Our new merchant dashboard uses AI to track customer behavior, showing you exactly how many people clicked your ad compared to how many actually contacted you. This granular data allows you to identify bottlenecks in your sales funnel and fix them before they cost you business.

### Turning Data into Action
If you are a car dealer in Kampala, you can now see the peak hours when your listings get the most traction. If you run an electronics shop, our system can alert you when demand for a specific model is rising based on search trends across the platform. This isn't just decoration; it’s actionable intelligence that helps you stock the right products at the right time, minimizing dead stock and maximizing cash flow.

### Optimization Through Recommendation
Beyond just showing numbers, our AI engine provides proactive recommendations. If your listing has high clicks but zero inquiries, our system might suggest that your price is outside the market average or that your photos need better lighting. By leveraging these insights, Yilick merchants are already seeing a 35% increase in conversion rates, simply by optimizing their product descriptions and photography based on our automated AI recommendations.

### Scaling Your Business with Precision
Scaling a business without data is like driving at night with no headlights. Yilick Analytics empowers you to see the road ahead. You can track performance over months, identify seasonal trends in the Ugandan market, and plan your marketing budget with precision. Whether you are a sole trader or a growing enterprise, our tools level the playing field, making data-driven growth accessible to every Ugandan shop owner.
EOD,
            'category' => 'Business Tips',
            'author' => 'Yilick Editorial',
            'read_time' => 10,
            'is_featured' => false,
            'is_published' => true,
            'published_at' => now()->subDay(),
        ]);

        // 3. Buyer/Trust Focus
        \App\Models\BlogPost::create([
            'title' => 'Trust in the Digital Era: The SafeTrade Escrow Revolution',
            'slug' => 'trust-digital-era-safetrade-escrow',
            'excerpt' => 'The biggest barrier to online trade in Uganda has always been trust. Our SafeTrade Escrow system is effectively removing that barrier, one transaction at a time.',
            'content' => <<<EOD
We have all heard the stories: a buyer pays for a high-end laptop, only to receive a faulty unit—or nothing at all. Conversely, sellers often worry about receiving fake payment confirmations or being robbed during meetups. Yilick is putting an end to this cycle of uncertainty with SafeTrade.

### How SafeTrade Works: The Mechanics of Trust
SafeTrade acts as a neutral third party in your transaction. When you buy through Yilick, your funds are held securely in our protected escrow system. The money is locked, and neither the buyer nor the seller can access it until the pre-defined conditions of the sale are met. This simple mechanic effectively removes the "leap of faith" required for online transactions.

### Verification and Peer-to-Peer Safety
The seller only receives payment once you have verified the item and confirmed its condition matches the listing. For the seller, this means guaranteed payment from a verified buyer. You no longer have to worry about "will they pay?" because the money is already secured before you release the product. 

### A Revolution for High-Value Items
This system is particularly revolutionary for high-value items like electronics, furniture, and vehicles, where the risk of fraud is historically high in Uganda. By providing a safe bridge between strangers, we are enabling commerce that previously felt too risky to attempt online. 

### Conclusion: A Brighter Future for Ugandan Trade
By standardizing trust, Yilick is creating a healthier, faster, and more professional digital economy for everyone. We believe that when people feel safe, they trade more. When they trade more, businesses grow and the local economy flourishes. SafeTrade is more than just a feature; it's our commitment to building the most reliable marketplace in East Africa.
EOD,
            'category' => 'Product News',
            'author' => 'Tech Team',
            'read_time' => 11,
            'is_featured' => false,
            'is_published' => true,
            'published_at' => now()->subDays(2),
        ]);
    }
}
