@extends('layouts.admin')

@section('title', 'Edit Blog Post')
@section('header_title', 'Edit Post: ' . $blog->title)

@section('content')
<div class="max-w-4xl mx-auto">
    <form action="{{ route('admin.blog.update', $blog) }}" method="POST" enctype="multipart/form-data" class="space-y-8">
        @csrf
        @method('PUT')
        
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <!-- Main Content -->
            <div class="md:col-span-2 space-y-6">
                <!-- Title & Slug -->
                <div class="bg-white p-6 rounded-3xl border border-gray-100 shadow-sm space-y-4">
                    <div>
                        <label class="block text-[10px] font-black uppercase text-gray-400 mb-1">Post Title</label>
                        <input type="text" name="title" value="{{ old('title', $blog->title) }}" class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-primary outline-none font-bold text-gray-900 text-lg transition-all focus:ring-4 focus:ring-primary/5" placeholder="Enter post title...">
                        @error('title') <p class="text-red-500 text-xs font-bold mt-1">{{ $message }}</p> @enderror
                    </div>
                </div>

                <!-- Content -->
                <div class="bg-white p-6 rounded-3xl border border-gray-100 shadow-sm space-y-4">
                    <div>
                        <label class="block text-[10px] font-black uppercase text-gray-400 mb-1">Content</label>
                        <textarea name="content" rows="15" class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-primary outline-none font-medium text-gray-700 transition-all focus:ring-4 focus:ring-primary/5 font-mono text-sm leading-relaxed">{{ old('content', $blog->content) }}</textarea>
                        @error('content') <p class="text-red-500 text-xs font-bold mt-1">{{ $message }}</p> @enderror
                    </div>
                    <div>
                        <label class="block text-[10px] font-black uppercase text-gray-400 mb-1">Excerpt</label>
                        <textarea name="excerpt" rows="3" class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-primary outline-none font-medium text-gray-700 transition-all focus:ring-4 focus:ring-primary/5">{{ old('excerpt', $blog->excerpt) }}</textarea>
                        @error('excerpt') <p class="text-red-500 text-xs font-bold mt-1">{{ $message }}</p> @enderror
                    </div>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="space-y-6">
                <!-- Publish -->
                <div class="bg-white p-6 rounded-3xl border border-gray-100 shadow-sm space-y-4">
                    <h3 class="font-bold text-gray-800 border-b border-gray-100 pb-2">Publishing</h3>
                    
                    <div class="flex items-center gap-3">
                        <input type="checkbox" name="is_published" id="is_published" value="1" {{ old('is_published', $blog->is_published) ? 'checked' : '' }} class="w-5 h-5 text-primary rounded border-gray-300 focus:ring-primary">
                        <label for="is_published" class="text-sm font-semibold text-gray-700 cursor-pointer">Published</label>
                    </div>

                    <div class="flex items-center gap-3">
                        <input type="checkbox" name="is_featured" id="is_featured" value="1" {{ old('is_featured', $blog->is_featured) ? 'checked' : '' }} class="w-5 h-5 text-vibrant-orange rounded border-gray-300 focus:ring-vibrant-orange">
                        <label for="is_featured" class="text-sm font-semibold text-gray-700 cursor-pointer">Featured Post</label>
                    </div>

                    <button type="submit" class="w-full py-3 bg-gray-900 text-white font-bold rounded-xl shadow-lg shadow-gray-900/20 hover:bg-black transition-all">
                        Update Post
                    </button>
                    
                    @if($blog->published_at)
                        <p class="text-[10px] text-gray-400 text-center mt-2">Originally published: {{ $blog->published_at->format('M d, Y') }}</p>
                    @endif
                </div>

                <!-- Organization -->
                <div class="bg-white p-6 rounded-3xl border border-gray-100 shadow-sm space-y-4">
                    <h3 class="font-bold text-gray-800 border-b border-gray-100 pb-2">Details</h3>
                    
                    <div>
                        <label class="block text-[10px] font-black uppercase text-gray-400 mb-1">Category</label>
                        <input type="text" name="category" value="{{ old('category', $blog->category) }}" class="w-full px-4 py-2 rounded-xl border border-gray-200 focus:border-primary outline-none text-sm font-semibold text-gray-700">
                        @error('category') <p class="text-red-500 text-xs font-bold mt-1">{{ $message }}</p> @enderror
                    </div>

                    <div>
                        <label class="block text-[10px] font-black uppercase text-gray-400 mb-1">Author Name</label>
                        <input type="text" name="author" value="{{ old('author', $blog->author) }}" class="w-full px-4 py-2 rounded-xl border border-gray-200 focus:border-primary outline-none text-sm font-semibold text-gray-700">
                        @error('author') <p class="text-red-500 text-xs font-bold mt-1">{{ $message }}</p> @enderror
                    </div>

                    <div>
                        <label class="block text-[10px] font-black uppercase text-gray-400 mb-1">Read Time (mins)</label>
                        <input type="number" name="read_time" value="{{ old('read_time', $blog->read_time) }}" min="1" class="w-full px-4 py-2 rounded-xl border border-gray-200 focus:border-primary outline-none text-sm font-semibold text-gray-700">
                        @error('read_time') <p class="text-red-500 text-xs font-bold mt-1">{{ $message }}</p> @enderror
                    </div>
                </div>

                <!-- Featured Image -->
                <div class="bg-white p-6 rounded-3xl border border-gray-100 shadow-sm space-y-4">
                    <h3 class="font-bold text-gray-800 border-b border-gray-100 pb-2">Featured Image</h3>
                    
                    <div class="relative w-full aspect-video bg-gray-50 rounded-xl border-2 border-dashed border-gray-200 hover:border-primary hover:bg-primary/5 transition-colors flex flex-col items-center justify-center cursor-pointer overflow-hidden group">
                        <input type="file" name="featured_image" accept="image/*" class="absolute inset-0 opacity-0 cursor-pointer z-10" onchange="previewImage(this)">
                        
                        <div class="text-center p-4 group-hover:scale-105 transition-transform {{ $blog->featured_image ? 'hidden' : '' }}" id="upload-placeholder">
                            <i class="fa-solid fa-cloud-arrow-up text-2xl text-gray-400 mb-2 group-hover:text-primary transition-colors"></i>
                            <div class="text-xs font-bold text-gray-500">Click to replace image</div>
                        </div>
                        
                        <img id="image-preview" src="{{ $blog->featured_image ? Storage::url($blog->featured_image) : '' }}" class="{{ $blog->featured_image ? '' : 'hidden' }} absolute inset-0 w-full h-full object-cover">
                    </div>
                    @error('featured_image') <p class="text-red-500 text-xs font-bold mt-1">{{ $message }}</p> @enderror
                </div>
            </div>
        </div>
    </form>
</div>

@push('scripts')
<script>
    function previewImage(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            
            reader.onload = function(e) {
                document.getElementById('image-preview').src = e.target.result;
                document.getElementById('image-preview').classList.remove('hidden');
                document.getElementById('upload-placeholder').classList.add('hidden');
            }
            
            reader.readAsDataURL(input.files[0]);
        }
    }
</script>
@endpush
@endsection
