@extends('layouts.admin')

@section('title', 'Blog Management')
@section('header_title', 'Blog Posts')

@section('content')
<div class="space-y-6">
    <!-- Header Actions -->
    <div class="flex justify-end">
        <a href="{{ route('admin.blog.create') }}" class="px-6 py-3 bg-gray-900 text-white font-bold rounded-xl shadow-lg shadow-gray-900/20 hover:bg-black hover:scale-[1.02] transition-all flex items-center gap-2">
            <i class="fa-solid fa-plus"></i>
            Create New Post
        </a>
    </div>

    <!-- Blog List -->
    <div class="bg-white rounded-3xl border border-gray-100 shadow-sm overflow-hidden">
        @if($posts->isNotEmpty())
            <table class="w-full text-left text-sm">
                <thead class="bg-gray-50 text-[10px] font-black uppercase text-gray-400">
                    <tr>
                        <th class="px-6 py-4">Post Details</th>
                        <th class="px-6 py-4">Category</th>
                        <th class="px-6 py-4">Author</th>
                        <th class="px-6 py-4">Status</th>
                        <th class="px-6 py-4 text-right">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-50">
                    @foreach($posts as $post)
                        <tr class="hover:bg-gray-50 transition-colors group">
                            <td class="px-6 py-4">
                                <div class="flex items-center gap-4">
                                    <div class="w-16 h-12 rounded-lg bg-gray-100 overflow-hidden flex-shrink-0 border border-gray-100">
                                        @if($post->featured_image)
                                            <img src="{{ Storage::url($post->featured_image) }}" class="w-full h-full object-cover">
                                        @else
                                            <div class="w-full h-full flex items-center justify-center text-gray-300">
                                                <i class="fa-solid fa-image"></i>
                                            </div>
                                        @endif
                                    </div>
                                    <div>
                                        <div class="font-bold text-gray-800 line-clamp-1 group-hover:text-primary transition-colors">{{ $post->title }}</div>
                                        <div class="text-[10px] text-gray-400 font-medium truncate max-w-[200px]">{{ $post->excerpt }}</div>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4">
                                <span class="px-2 py-1 rounded-md bg-gray-100 text-gray-600 text-[10px] font-bold uppercase tracking-wider">
                                    {{ $post->category }}
                                </span>
                            </td>
                            <td class="px-6 py-4">
                                <div class="font-medium text-gray-700">{{ $post->author }}</div>
                            </td>
                            <td class="px-6 py-4">
                                <div class="flex flex-col gap-1">
                                    <div class="flex items-center gap-2">
                                        <span class="w-2 h-2 rounded-full {{ $post->is_published ? 'bg-emerald-500' : 'bg-gray-300' }}"></span>
                                        <span class="text-xs font-bold {{ $post->is_published ? 'text-emerald-600' : 'text-gray-500' }}">
                                            {{ $post->is_published ? 'Published' : 'Draft' }}
                                        </span>
                                    </div>
                                    @if($post->is_featured)
                                        <span class="text-[10px] font-black text-vibrant-orange uppercase tracking-wide flex items-center gap-1">
                                            <i class="fa-solid fa-star text-[8px]"></i> Featured
                                        </span>
                                    @endif
                                </div>
                            </td>
                            <td class="px-6 py-4 text-right">
                                <div class="flex items-center justify-end gap-2">
                                    <a href="{{ route('admin.blog.edit', $post) }}" class="w-8 h-8 rounded-lg bg-blue-50 text-blue-600 hover:bg-blue-100 flex items-center justify-center transition-colors" title="Edit">
                                        <i class="fa-solid fa-pen text-xs"></i>
                                    </a>
                                    <form action="{{ route('admin.blog.destroy', $post) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this post?');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="w-8 h-8 rounded-lg bg-red-50 text-red-600 hover:bg-red-100 flex items-center justify-center transition-colors" title="Delete">
                                            <i class="fa-solid fa-trash text-xs"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            
            <div class="p-6 border-t border-gray-50">
                {{ $posts->links() }}
            </div>
        @else
            <div class="p-12 text-center">
                <div class="w-16 h-16 bg-gray-50 rounded-2xl flex items-center justify-center mx-auto mb-4 text-gray-300">
                    <i class="fa-solid fa-newspaper text-2xl"></i>
                </div>
                <h3 class="text-lg font-bold text-gray-900">No blog posts yet</h3>
                <p class="text-gray-500 text-sm mt-1 mb-6">Create your first blog post to verify functionalities.</p>
                <a href="{{ route('admin.blog.create') }}" class="inline-flex items-center gap-2 px-6 py-3 bg-gray-900 text-white font-bold rounded-xl hover:bg-black transition-all">
                    <i class="fa-solid fa-plus"></i>
                    Create Post
                </a>
            </div>
        @endif
    </div>
</div>
@endsection
